﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<script runat="server">

    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
    
        }
    
        FromTo okres = FromTo.Year(Date.Today.Year);
        [Required]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value==FromTo.Empty)
                    value = FromTo.All;
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
    
    class Total {
        readonly string nazwa;
        readonly int ilosc, przyPracy;
        public Total(string nazwa, int ilosc, int przyPracy) {
            this.nazwa = nazwa;
            this.ilosc = ilosc;
            this.przyPracy = przyPracy;
        }
        public string Nazwa {
            get { return nazwa; }
        }
        public int Ilosc {
            get { return ilosc; }
        }
        public int PrzyPracy {
            get { return przyPracy; }
        }
    }
    
    
    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }
    
    int iW, iP, iN, iNP, iC, iCP, iS, iSP;
    
    void dc_ContextLoad(Object sender, EventArgs e) {
        ReportHeader["OKRES"] = pars.Okres.ToString();
        KadryModule kadry = KadryModule.GetInstance(dc);
        SubTable st = kadry.Wypadki.WgData;
        if (pars.Okres!=FromTo.All)
            st = new SubTable(st, pars.Okres);
        Grid.DataSource = st;
    }
    
    void Grid_BeforeRow(Object sender, RowEventArgs args) {
        iW ++;
        bool bb = false;
    
        Wypadek wypadek = (Wypadek)args.Row;
        if (wypadek.PrzyPracy) {
            cP.EditValue = "X";
            iP++;
            bb = true;
        }
    
        if (wypadek.Ciezki) {
            cC.EditValue = "X";
            iC++;
            if (bb)
                iCP++;
        }
    
        if (wypadek.Smiertelny) {
            cS.EditValue = "X";
            iS++;
            if (bb)
                iSP++;
        }
    
        if (wypadek.Niezdolnosc) {
            cN.EditValue = "X";
            iN++;
            if (bb)
                iNP++;
        }
    }
    
    void Grid_AfterRender(Object sender, EventArgs e) {
        Grid1.DataSource = new Total[] {
                                            new Total("Razem", iW, iP),
                                            new Total("Powodujące czasową niezdolność do pracy", iN, iNP),
                                            new Total("Ciężkie", iC, iCP),
                                            new Total("Śmiertelne", iS, iSP)
                                        };
    }

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Ewidencja wypadków</title> 
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Ewidencja wypadków|</strong>Za okres: <strong>%OKRES%" runat="server"></eb:ReportHeader>
        <p>
            <ea:Grid id="Grid" runat="server" OnAfterRender="Grid_AfterRender" OnBeforeRow="Grid_BeforeRow" RowTypeName="Soneta.Kadry.Wypadek,Soneta.KadryPlace">
                <Columns>
                    <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Left" DataMember="Data" Caption="Data"></ea:GridColumn>
                    <ea:GridColumn Width="12" Align="Left" DataMember="SKW" Caption="SKW"></ea:GridColumn>
                    <ea:GridColumn DataMember="Pracownik.NazwiskoImię" Caption="Pracownik"></ea:GridColumn>
                    <ea:GridColumn Width="12" Align="Left" DataMember="ProtokolNumer" Caption="Protok&#243;ł~numer"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Left" DataMember="ProtokolData" Caption="Protok&#243;ł~data"></ea:GridColumn>
                    <ea:GridColumn Width="4" Align="Center" Caption="P" ID="cP"></ea:GridColumn>
                    <ea:GridColumn Width="4" Align="Center" Caption="C" ID="cC"></ea:GridColumn>
                    <ea:GridColumn Width="4" Align="Center" Caption="Ś" ID="cS"></ea:GridColumn>
                    <ea:GridColumn Width="4" Align="Center" Caption="N" ID="cN"></ea:GridColumn>
                </Columns>
            </ea:Grid>
            <font size="2"><strong>P</strong>-przy pracy, <strong>C</strong>-ciężki, <strong>Ś</strong>-śmiertelny, <strong>N</strong>-powodujący
            czasową niezdolność do pracy</font> 
        </p>
        <p>
            <ea:Grid id="Grid1" runat="server">
                <Columns>
                    <ea:GridColumn Width="35" Align="Right" DataMember="Nazwa" Caption=" "></ea:GridColumn>
                    <ea:GridColumn Width="12" Align="Right" DataMember="Ilosc" Caption="Razem" HideZero="True"></ea:GridColumn>
                    <ea:GridColumn Width="12" Align="Right" DataMember="PrzyPracy" Caption="Przy pracy" HideZero="True"></ea:GridColumn>
                </Columns>
            </ea:Grid>
            &nbsp;<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
        </p>
    </form>
</body>
</html>
